/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills;

import dev.toma.gunsrpg.api.common.skill.IDescriptionProvider;
import dev.toma.gunsrpg.common.LootStashDetectorHandler;
import dev.toma.gunsrpg.common.skills.SimpleSkill;
import dev.toma.gunsrpg.common.skills.core.DescriptionContainer;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.SkillUtil;
import net.minecraft.util.text.ITextComponent;

public class TreasureHunterSkill
extends SimpleSkill
implements IDescriptionProvider {
    private static final DetectionRadius[] RADII = new DetectionRadius[]{new DetectionRadius(40.0f, 6.0f), new DetectionRadius(55.0f, 5.0f), new DetectionRadius(75.0f, 3.0f)};
    private final DescriptionContainer container;
    private final int level;

    public TreasureHunterSkill(SkillType<? extends TreasureHunterSkill> type, int level) {
        super(type);
        this.level = level - 1;
        DetectionRadius radius = this.getRadius();
        this.container = new DescriptionContainer(type);
        this.container.addProperty("maxRange", Math.round(radius.maxRange));
        this.container.addProperty("sensitivity", Math.round(radius.foundRange));
    }

    @Override
    public ITextComponent[] supplyDescription(int desiredLineCount) {
        return SkillUtil.Localizations.generateAndMerge(desiredLineCount, this.getType(), this.container.getLines());
    }

    public DetectionRadius getRadius() {
        return RADII[this.level];
    }

    public static final class DetectionRadius {
        private final float maxRange;
        private final float foundRange;

        DetectionRadius(float maxRange, float foundRange) {
            this.maxRange = maxRange;
            this.foundRange = foundRange;
        }

        public float getSoundIntensity(double distance) {
            if (distance <= (double)this.foundRange) {
                return 1.0f;
            }
            if (distance > (double)this.maxRange) {
                return 0.0f;
            }
            double diff = distance - (double)this.foundRange;
            double limit = this.maxRange - this.foundRange;
            return (float)(diff / limit);
        }

        public LootStashDetectorHandler.Status getStatusByDistance(double distance) {
            if (distance <= (double)this.foundRange) {
                return LootStashDetectorHandler.Status.LOCATED;
            }
            if (distance <= (double)this.maxRange) {
                return LootStashDetectorHandler.Status.NEARBY;
            }
            return LootStashDetectorHandler.Status.UNDETECTED;
        }
    }
}

